unit Unit1;
//        
//    
interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, GraphXYv1, ExtCtrls;

type
  TForm1 = class(TForm)
    Edit1: TEdit;
    Edit2: TEdit;
    Edit3: TEdit;
    Edit4: TEdit;
    Edit5: TEdit;
    Edit6: TEdit;
    Edit7: TEdit;
    Edit8: TEdit;
    bttFindXRoot: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Edit9: TEdit;
    Label10: TLabel;
    Edit10: TEdit;
    Label11: TLabel;
    Panel1: TPanel;
    Bevel1: TBevel;
    CheckBox1: TCheckBox;
    Bevel3: TBevel;
    Label13: TLabel;
    Edit12: TEdit;
    Label14: TLabel;
    Edit13: TEdit;
    Label15: TLabel;
    Bevel4: TBevel;
    bttFindFrame: TButton;
    bttShowPoly: TButton;
    procedure bttFindXRootClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure bttShowPolyClick(Sender: TObject);
    procedure bttFindFrameClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure LoadSourceData();
  end;

var
  Form1: TForm1;

// =====================================
//     
const  DeltaF   = 0.0001;   //     
const  FindNumb = 64;       //     

// =====================================
//     
var  //  
  AI   : array [0..5] of double;
var
  F0   : double;            //    
  XH   : double;            //     
  FH   : double;            //     
  XK   : double;            //     
  FK   : double;            //     
  FUP  : boolean;           //  -   - True,  - False

// *************************************
//     
var GraphXY1 : TGraphXY;
//    
var
    GraphColor : TColor;        //    
    ColorFH    : TColor;        //   
    ColorFK    : TColor;        //   
    ColorFRoot : TColor;        //   
    ColorPoly  : TColor;        //   
    ColorF0    : TColor;        //   F0
// =====================================
//     
const PointRadius = 2;         //      
const GPointNumb = 100;        //    

//  TPointXY    GraphXYv1
//     
var   PolyTab1   : array[1..GPointNumb] of TPointXY;

//     F0
var   PolyTab2   : array[1..2] of TPointXY;


// *************************************
//     
//     
function POL1 (A : array of double; X : double):double;
//     ,   
function FindXFrame(): boolean;
// =====================================
//       
procedure ShowPoly ();
//     
function FindXRoot(): boolean;

// *************************************
// *************************************
implementation
{$R *.dfm}
// *************************************
// *************************************

// ===============================================
//     
// ===============================================
//     
function POL1 (A : array of double; X : double):double;
var MaxInd : integer;
    Ind    : integer;
    Sum    : double;
    P      : double;
begin
 MaxInd := High(A);
 Sum := 0;
 P   := 1;
 for Ind := 0 to MaxInd
 do begin
   Sum := Sum + A[Ind]*P;
   P := P * X;
 end;
 Result := Sum;
end;

//     ,   
function FindXFrame(): boolean;
var    Found    : boolean;   //   " "
       ErEnd    : boolean;   //   
       CNumb    : integer;   //   
       WFH, WFK : double;    //   
       WSTR     : string;    //   
begin
 ErEnd := False;
 Found := False;
 CNumb := 1;
 //     
 Form1.Edit13.Text :='';
 repeat
     if FUP
     then begin
       //   
       if (FH < F0) and (FK < F0)
       then begin
         //   
         XK := XK + (XK - XH) * 2;
         WFK := POL1(AI,XK);
         //    
         if WFK > FK then FK := WFK else ErEnd := True;
       end;
       if (FH > F0) and (FK > F0)
       then begin
         //   
         XH := XH - (XK - XH) * 2;
         WFH := POL1(AI,XH);
         //    
         if WFH < FH then FH := WFH else ErEnd := True;
       end;
     end
     else begin
       //   
       if (FH < F0) and (FK < F0)
       then begin
         //   
         XH := XH - (XK - XH) * 2;
         WFH := POL1(AI,XH);
         //    
         if WFH > FH then FH := WFH else ErEnd := True;
       end;
       if (FH > F0) and (FK > F0)
       then begin
         //   
         XK := XK + (XK - XH) * 2;
         WFK := POL1(AI,XK);
         //    
         if WFK < FK then FK := WFK else ErEnd := True;
       end;
     end; {if FUP}

     //     
     Form1.Edit10.Text := FloatToStr(XH);
     Form1.Edit9.Text  := FloatToStr(XK);
     //    
     Form1.Edit13.Text := IntToStr(CNumb);

     if not ErEnd
     then begin
       //    
       if FUP
       then begin
          //   
          if (FH <= F0) and (FK >= F0) then Found := True;
       end
       else begin
          //   
          if (FH >= F0) and (FK <= F0) then Found := True;
       end;
     end
     else begin
       WSTR := '    dF(X)/dX  .'
            +  '      .'
            +  '   X    .';
       ShowMessage(WSTR);
     end;
     CNumb := CNumb + 1;
 until Found or ErEnd or (CNumb > FindNumb);
 // ========================
 if (CNumb > FindNumb)
 then begin
     ShowMessage('          ');
 end;
 // =============
 Result := Found;
end;

//     
function FindXRoot(): boolean;
var    Found    : boolean;   //   " "
       CNumb    : integer;   //   
       NewX     : double;    //     - 
       NewF     : double;    //    F - 
begin
  Found := False;
  CNumb := 0;
   //        
  if (Abs(FH - F0) <= DeltaF) or (Abs(FK - F0) <= DeltaF)
  then begin
     //  
     Found := true;
     if (Abs(FH - F0) <= DeltaF)
     then begin
        NewX := XH;
        NewF := FH;
     end
     else begin
        NewX := XK;
        NewF := FK;
     end;
     //    
     Form1.Edit7.Text  := FloatToStr(NewX);
     Form1.Edit12.Text := FloatToStr(NewF);
     //  TGraphXY
     GraphXY1.PaintPointXY(NewX,NewF,ColorFRoot,PointRadius);
  end
  else begin
      // ,   ,  
      repeat
         //   
         NewX := XH + (XK-XH)/2;
         NewF := POL1(AI,NewX);
         if Abs(NewF - F0) <= DeltaF
         then begin
            //  
            Found := true;
            //    
            Form1.Edit7.Text  := FloatToStr(NewX);
            Form1.Edit12.Text := FloatToStr(NewF);
            //  TGraphXY
            GraphXY1.PaintPointXY(NewX,NewF,ColorFRoot,PointRadius);
         end
         else begin
            //    
            if FUP
            then begin
               //   
               if F0 > NewF
               then begin
                  XH := NewX;
                  FH := NewF;
                  //  TGraphXY
                  GraphXY1.PaintPointXY(NewX,NewF,ColorFH,PointRadius);
               end
               else begin
                  XK := NewX;
                  FK := NewF;
                  //  TGraphXY
                  GraphXY1.PaintPointXY(NewX,NewF,ColorFK,PointRadius);
               end;
            end
            else begin
               //   
               if F0 < NewF
               then begin
                  XH := NewX;
                  FH := NewF;
                  //  TGraphXY
                  GraphXY1.PaintPointXY(NewX,NewF,ColorFH,PointRadius);
               end
               else begin
                  XK := NewX;
                  FK := NewF;
                  //  TGraphXY
                  GraphXY1.PaintPointXY(NewX,NewF,ColorFK,PointRadius);
               end;
            end;
         end; {if Abs(NewF - F0) <= DeltaF}
         CNumb := CNumb + 1;
         if Form1.CheckBox1.Checked
         then begin
            ShowMessage('  '+ IntToStr(CNumb));
         end;
      until Found or (CNumb > FindNumb)
  end; {if (FH = F0) or (FK = F0)}
  // ========================
  //    
  //    
  Form1.Edit13.Text := IntToStr(CNumb);
  if Found
  then begin
     ShowMessage(' !');
  end
  else begin
     //    
     Form1.Edit7.Text  := '';
     Form1.Edit12.Text := '';
     ShowMessage('   !');
  end;
  // =============
  Result := Found;
end;


//   
procedure TForm1.LoadSourceData();
begin
  Edit7.Text  := '';
  Edit12.Text := '';
  Edit13.Text := '';
  // ===========================
  //  
  AI[0]:= StrToFloat(Edit1.Text);
  AI[1]:= StrToFloat(Edit2.Text);
  AI[2]:= StrToFloat(Edit3.Text);
  AI[3]:= StrToFloat(Edit4.Text);
  AI[4]:= StrToFloat(Edit5.Text);
  AI[5]:= StrToFloat(Edit6.Text);
  //  XH, XK,
  XH:= StrToFloat(Edit10.Text);
  XK:= StrToFloat(Edit9.Text);
  //      
  F0:= StrToFloat(Edit8.Text);
  // ===========================
  //  
  FH := POL1(AI,XH);
  FK := POL1(AI,XK);
  //     
  FUP:=False;
  if FK > FH then FUP:=True;
end;

// ===============================================
//    
// ===============================================
//      
procedure TForm1.bttShowPolyClick(Sender: TObject);
begin
  LoadSourceData();
  ShowPoly();
end;
//    
procedure TForm1.bttFindFrameClick(Sender: TObject);
begin
  LoadSourceData();
  FindXFrame();
  ShowPoly();
end;

//          
procedure TForm1.bttFindXRootClick(Sender: TObject);
begin
  LoadSourceData();
  if FK = FH
  then begin
    ShowMessage('  .  ');
  end
  else begin
    // ===========================
    //   
    // ===========================
    //        
    if FindXFrame()
    then begin
        //   
        //  
        ShowPoly();
        //  
        FindXRoot();
    end;
  end;
end;

// ===============================================
//     TGraphXY
// ===============================================
//     ,    F(X)  F0
procedure ShowPoly ();
var IndX  : integer;
    StepX : double; //       
    X     : double;
begin
 //      
 StepX := (XK-XH)/(High(PolyTab1)-Low(PolyTab1));
 X := XH;
 for IndX := Low(PolyTab1) to High(PolyTab1) do
 begin
   PolyTab1[IndX].X := X;
   PolyTab1[IndX].Y := POL1(AI,X); //   
   X := X + StepX;
 end;
 //      F0
 PolyTab2[1].X := XH;
 PolyTab2[1].Y := F0;
 PolyTab2[2].X := XK;
 PolyTab2[2].Y := F0;
 //     
 GraphXY1.FullEraseGraphXY();
 //   
 GraphXY1.ShowGraphXY(PolyTab1, ColorPoly);
//   F0
 GraphXY1.ShowGraphXY(PolyTab2, ColorF0);
 GraphXY1.SubscriptPointXY(XH+(XK-XH)/4,F0,ColorF0,'F0');
 //   
 GraphXY1.PaintPointXY(XH,FH,ColorFH,4);
 GraphXY1.PaintPointXY(XK,FK,ColorFK,4);
end;
// ===============================================
//     TGraphXY
// ===============================================
//     
procedure TForm1.FormCreate(Sender: TObject);
begin
  if GraphXY1 = nil
   then begin
      //       
      GraphXY1 := TGraphXY.Create();
      GraphXY1.OpenGraphXY(Panel1);
      //   
      GraphXY1.GraphTitul := ',     ';
      GraphColor := RGB(64,64,164);
      ColorFH     := RGB(255,0,255);
      ColorFK     := RGB(0,255,255);
      ColorFRoot  := RGB(255,255,255);
      ColorPoly   := RGB(0,0,255);
      ColorF0     := RGB(240,240,240);
   end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
  if GraphXY1 <> nil
  then begin
      GraphXY1 := GraphXY1.CloseGraphXY(GraphXY1);
  end;
end;


end.
